/*
 * Quasseldroid - Quassel client for Android
 *
 * Copyright (c) 2020 Janne Mareike Koschinski
 * Copyright (c) 2020 The Quassel Project
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package de.kuschku.libquassel.protocol.primitive.serializer

import de.kuschku.libquassel.quassel.QuasselFeatures
import de.kuschku.libquassel.quassel.syncables.interfaces.IDccConfig
import de.kuschku.libquassel.util.nio.ChainedByteBuffer
import java.nio.ByteBuffer

object DccConfig_PortSelectionModeSerializer : Serializer<IDccConfig.PortSelectionMode> {
  override fun serialize(buffer: ChainedByteBuffer, data: IDccConfig.PortSelectionMode,
                         features: QuasselFeatures) {
    UByteSerializer.serialize(buffer, data.value, features)
  }

  override fun deserialize(buffer: ByteBuffer,
                           features: QuasselFeatures): IDccConfig.PortSelectionMode {
    return IDccConfig.PortSelectionMode.of(UByteSerializer.deserialize(buffer, features))
  }
}
