/*
 * Quasseldroid - Quassel client for Android
 *
 * Copyright (c) 2019 Janne Koschinski
 * Copyright (c) 2019 The Quassel Project
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package de.kuschku.quasseldroid.dagger

import com.google.gson.GsonBuilder
import dagger.Module
import dagger.Provides
import de.kuschku.quasseldroid.util.avatars.MatrixApi
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory

@Module
object AppModule {
  @Provides
  @JvmStatic
  fun provideGson() = GsonBuilder().setPrettyPrinting().create()

  @Provides
  @JvmStatic
  fun provideMatrixApi() = Retrofit.Builder()
    .baseUrl("https://matrix.org/")
    .addConverterFactory(GsonConverterFactory.create(GsonBuilder().setLenient().create()))
    .build()
    .create(MatrixApi::class.java)
}
