/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2013-2023 Chaosdorf e.V.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package de.chaosdorf.mete.v1

import de.chaosdorf.mete.DrinkId
import de.chaosdorf.mete.PwaManifest
import de.chaosdorf.mete.UserId
import retrofit2.http.GET
import retrofit2.http.Path

interface MeteApiV1 {
  @GET("manifest.json")
  suspend fun getManifest(): PwaManifest?

  @GET("api/v1/audits.json")
  suspend fun getAudits(): List<AuditEntryModelV1>

  @GET("api/v1/barcodes.json")
  suspend fun listBarcodes(): List<BarcodeModelV1>

  @GET("api/v1/barcodes/{id}.json")
  suspend fun getBarcode(): BarcodeModelV1?

  @GET("api/v1/drinks.json")
  suspend fun listDrinks(): List<DrinkModelV1>

  @GET("api/v1/drinks/{id}.json")
  suspend fun getDrink(@Path("id") id: DrinkId): DrinkModelV1?

  @GET("api/v1/users.json")
  suspend fun listUsers(): List<UserModelV1>

  @GET("api/v1/users/{id}.json")
  suspend fun getUser(@Path("id") id: UserId): UserModelV1?

  @GET("api/v1/users/{id}/deposit.json")
  suspend fun deposit(@Path("id") id: UserId)

  @GET("api/v1/users/{id}/payment.json")
  suspend fun payment(@Path("id") id: UserId)

  @GET("api/v1/users/{id}/buy.json")
  suspend fun buy(@Path("id") id: UserId)

  @GET("api/v1/users/{id}/buy_barcode.json")
  suspend fun buyWithBarcode(@Path("id") id: UserId)

  @GET("api/v1/users/stats.json")
  suspend fun getStats()
}
