import {Content} from "./models/Content";
import {useQuery} from "react-query";
import {getContent, listEpisodes} from "./queries";
import {Instalment} from "./models/Instalment";
import {useApiEndpoint} from "./ApiEndpointContext";
import {ContentMeta} from "./models/dto/ContentMeta";

export function useEpisodes(item: Content | undefined): [Instalment[], boolean, unknown] {
    const apiEndpoint = useApiEndpoint();

    const {data, isLoading, error} = useQuery(
        ["episodes", item?.ids?.uuid],
        () => item?.kind === "show"
            ? listEpisodes(apiEndpoint, item.ids.uuid)
            : []
    )

    return [data || [], isLoading, error];
}

export function useContent(id: string): [ContentMeta | null, boolean, unknown] {
    const apiEndpoint = useApiEndpoint();

    const {data, isLoading, error} = useQuery(
        ["media", id],
        () => getContent(apiEndpoint, id)
    )

    return [data || null, isLoading, error];
}
